<div>
    <div class="modal fade" id="addRoleModal" tabindex="-1" aria-hidden="true" wire:ignore.self>
        <div class="modal-dialog modal-lg modal-simple modal-dialog-centered modal-add-new-role" wire:ignore.self>
            <div class="modal-content">
                <div class="modal-body">
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    <div class="text-center mb-6">
                        <h4 class="role-title mb-2">Add New Role</h4>
                        <p>Set role permissions</p>
                    </div>
                    <!-- Add role form -->
                    <form id="addRoleForm" class="row g-6" onsubmit="return false">
                        <div class="col-12">
                            <label class="form-label" for="modalRoleName">Role Name</label>
                            <input type="text" wire:model="rolename" class="form-control"
                                placeholder="Enter a role name" tabindex="-1" />
                        </div>
                        <div class="col-12">
                            <h5 class="mb-6">Role Permissions</h5>
                            <!-- Permission table -->
                            <div class="table-responsive">
                                <table class="table table-flush-spacing">
                                    <tbody>
                                        <tr>
                                            <td class="text-nowrap fw-medium text-heading">Administrator Access <i
                                                    class="ti ti-info-circle" data-bs-toggle="tooltip"
                                                    data-bs-placement="top"
                                                    title="Allows a full access to the system"></i></td>
                                            <td>
                                                <div class="d-flex justify-content-end">
                                                    <div class="form-check mb-0">
                                                        <input class="form-check-input" type="checkbox"
                                                            id="selectAll" />
                                                        <label class="form-check-label" for="selectAll">
                                                            Select All
                                                        </label>
                                                    </div>
                                                </div>
                                            </td>
                                        </tr>
                                        @foreach ($permissions as $permission)
                                            <tr>
                                                <td class="text-nowrap fw-medium text-heading">User Management</td>
                                                <td>
                                                    <div class="d-flex justify-content-end">
                                                        <div class="form-check mb-0 me-4 me-lg-12">
                                                            <input class="form-check-input" type="checkbox"
                                                                wire:model="permissionsarray"
                                                                value="{{ $permission->name }}Read" />
                                                            <label class="form-check-label" for="userManagementRead">
                                                                Read
                                                            </label>
                                                        </div>
                                                        <div class="form-check mb-0 me-4 me-lg-12">
                                                            <input class="form-check-input" type="checkbox"
                                                                wire:model="permissionsarray"
                                                                value="{{ $permission->name }}Write" />
                                                            <label class="form-check-label" for="userManagementWrite">
                                                                Write
                                                            </label>
                                                        </div>
                                                        <div class="form-check mb-0">
                                                            <input class="form-check-input" type="checkbox"
                                                                wire:model="permissionsarray"
                                                                value="{{ $permission->name }}Create" />
                                                            <label class="form-check-label" for="userManagementCreate">
                                                                Create
                                                            </label>
                                                        </div>
                                                    </div>
                                                </td>
                                            </tr>
                                        @endforeach

                                    </tbody>
                                </table>
                            </div>
                            <!-- Permission table -->
                        </div>
                        <div class="col-12 text-center">
                            <button type="button" class="btn btn-primary me-3 " wire:click="AddRole"
                                wire:loading.attr="disabled">Submit</button>
                            <button type="reset" class="btn btn-label-secondary" data-bs-dismiss="modal"
                                aria-label="Close">Cancel</button>
                        </div>
                    </form>
                    <!--/ Add role form -->
                </div>
            </div>
        </div>
    </div>
</div>
