<div class="col-12 col-lg-12 p-5">
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5 class="card-title mb-0">
                <i class="tf-icons ti ti-hash me-2"></i>
                {{ __('settings.reference_number.title') }}
            </h5>
            <button type="button" class="btn btn-primary" wire:click="generatePreview">
                <i class="tf-icons ti ti-eye me-1"></i>
                {{ __('settings.reference_number.preview_button') }}
            </button>
        </div>

        <div class="card-body">
            <form wire:submit.prevent="saveSettings">
                <div class="row g-4">
                    <!-- Basic Settings -->
                    <div class="col-md-6">
                        <div class="card border-0 shadow-sm">
                            <div class="card-header bg-light">
                                <h6 class="mb-0">
                                    <i class="tf-icons ti ti-tools me-2 text-primary"></i>
                                    {{ __('settings.reference_number.basic_settings') }}
                                </h6>
                            </div>
                            <div class="card-body">
                                <div class="mb-3">
                                    <label class="form-label">{{ __('settings.reference_number.prefix') }}</label>
                                    <input type="text" class="form-control" wire:model="referenceSettings.prefix"
                                        placeholder="{{ __('settings.reference_number.prefix_placeholder') }}">
                                    @error('referenceSettings.prefix')
                                        <small class="text-danger">{{ $message }}</small>
                                    @enderror
                                </div>

                                <div class="mb-3">
                                    <label class="form-label">{{ __('settings.reference_number.separator') }}</label>
                                    <input type="text" class="form-control" wire:model="referenceSettings.separator"
                                        placeholder="{{ __('settings.reference_number.separator_placeholder') }}">
                                    @error('referenceSettings.separator')
                                        <small class="text-danger">{{ $message }}</small>
                                    @enderror
                                </div>

                                <div class="mb-3">
                                    <label
                                        class="form-label">{{ __('settings.reference_number.branch_code_length') }}</label>
                                    <input type="number" class="form-control"
                                        wire:model="referenceSettings.branch_code_length" min="1" max="10">
                                    @error('referenceSettings.branch_code_length')
                                        <small class="text-danger">{{ $message }}</small>
                                    @enderror
                                </div>

                                <div class="mb-3">
                                    <label
                                        class="form-label">{{ __('settings.reference_number.transaction_id_length') }}</label>
                                    <input type="number" class="form-control"
                                        wire:model="referenceSettings.transaction_id_length" min="1"
                                        max="10">
                                    @error('referenceSettings.transaction_id_length')
                                        <small class="text-danger">{{ $message }}</small>
                                    @enderror
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Advanced Settings -->
                    <div class="col-md-6">
                        <div class="card border-0 shadow-sm">
                            <div class="card-header bg-light">
                                <h6 class="mb-0">
                                    <i class="tf-icons ti ti-settings me-2 text-warning"></i>
                                    {{ __('settings.reference_number.advanced_settings') }}
                                </h6>
                            </div>
                            <div class="card-body">
                                <div class="mb-3">
                                    <div class="form-check form-switch">
                                        <input class="form-check-input" type="checkbox"
                                            wire:model="referenceSettings.auto_increment" id="autoIncrement">
                                        <label class="form-check-label" for="autoIncrement">
                                            {{ __('settings.reference_number.auto_increment') }}
                                        </label>
                                    </div>
                                    <small
                                        class="text-muted">{{ __('settings.reference_number.auto_increment_help') }}</small>
                                </div>

                                @if ($referenceSettings['auto_increment'])
                                    <div class="mb-3">
                                        <label
                                            class="form-label">{{ __('settings.reference_number.current_sequence') }}</label>
                                        <input type="number" class="form-control"
                                            wire:model="referenceSettings.current_sequence" min="1">
                                        @error('referenceSettings.current_sequence')
                                            <small class="text-danger">{{ $message }}</small>
                                        @enderror
                                    </div>

                                    <div class="mb-3">
                                        <div class="form-check form-switch">
                                            <input class="form-check-input" type="checkbox"
                                                wire:model="referenceSettings.reset_daily" id="resetDaily">
                                            <label class="form-check-label" for="resetDaily">
                                                {{ __('settings.reference_number.reset_daily') }}
                                            </label>
                                        </div>
                                        <small
                                            class="text-muted">{{ __('settings.reference_number.reset_daily_help') }}</small>
                                    </div>
                                @endif

                                <div class="mb-3">
                                    <label
                                        class="form-label">{{ __('settings.reference_number.custom_format') }}</label>
                                    <input type="text" class="form-control"
                                        wire:model="referenceSettings.custom_format"
                                        placeholder="{{ __('settings.reference_number.custom_format_placeholder') }}">
                                    <small class="text-muted">
                                        {{ __('settings.reference_number.custom_format_help') }}
                                    </small>
                                    @error('referenceSettings.custom_format')
                                        <small class="text-danger">{{ $message }}</small>
                                    @enderror
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Preview Section -->
                    @if ($showPreview)
                        <div class="col-12">
                            <div class="card border-0 shadow-sm">
                                <div class="card-header bg-light">
                                    <h6 class="mb-0">
                                        <i class="tf-icons ti ti-eye me-2 text-info"></i>
                                        {{ __('settings.reference_number.preview_title') }}
                                    </h6>
                                </div>
                                <div class="card-body text-center">
                                    <div class="display-6 text-primary mb-3">{{ $previewReference }}</div>
                                    <p class="text-muted">{{ __('settings.reference_number.preview_description') }}</p>
                                </div>
                            </div>
                        </div>
                    @endif

                    <!-- Actions -->
                    <div class="col-12">
                        <div class="d-flex justify-content-between">
                            <button type="button" class="btn btn-warning" wire:click="resetSequence"
                                @if (!$referenceSettings['auto_increment']) disabled @endif>
                                <i class="tf-icons ti ti-refresh me-1"></i>
                                {{ __('settings.reference_number.reset_sequence') }}
                            </button>

                            <div>
                                <button type="button" class="btn btn-secondary me-2" wire:click="loadSettings">
                                    <i class="tf-icons ti ti-rotate me-1"></i>
                                    {{ __('settings.reference_number.reset_to_defaults') }}
                                </button>
                                <button type="submit" class="btn btn-primary">
                                    <i class="tf-icons ti ti-device-floppy me-1"></i>
                                    {{ __('settings.reference_number.save_settings') }}
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
