<div>
    <div class="row card">
        <div class="card-body">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h5 class="card-title text-primary">
                    <i class="ti ti-shield-check me-2"></i>
                    إعدادات التحقق من التحويلات
                </h5>
                <div>
                    <button type="button" class="btn btn-outline-secondary btn-sm me-2" wire:click="resetToDefaults">
                        <i class="ti ti-refresh me-1"></i>
                        إعادة تعيين
                    </button>
                    <button type="button" class="btn btn-primary btn-sm" wire:click="saveTransferValidationSettings">
                        <i class="ti ti-device-floppy me-1"></i>
                        حفظ الإعدادات
                    </button>
                </div>
            </div>

            <form wire:submit.prevent="saveTransferValidationSettings">
                <!-- Beneficiary Name Settings -->
                <div class="row mb-4">
                    <div class="col-12">
                        <div class="card border-primary border-2">
                            <div class="card-header bg-primary text-white">
                                <h6 class="mb-0">
                                    <i class="ti ti-user me-2"></i>
                                    إعدادات اسم المستفيد
                                </h6>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-6">
                                        <label class="form-label fw-bold">
                                            الحد الأدنى لعدد الكلمات
                                            <span class="text-danger">*</span>
                                        </label>
                                        <input type="number"
                                            class="form-control @error('transferValidation.beneficiary_name_min_words') is-invalid @enderror"
                                            wire:model="transferValidation.beneficiary_name_min_words" min="1"
                                            max="50" placeholder="مثال: 2" />
                                        @error('transferValidation.beneficiary_name_min_words')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                        <small class="form-text text-muted">أقل عدد من الكلمات المطلوبة لاسم
                                            المستفيد</small>
                                    </div>

                                    <div class="col-md-6">
                                        <label class="form-label fw-bold">
                                            الحد الأقصى لعدد الكلمات
                                            <span class="text-danger">*</span>
                                        </label>
                                        <input type="number"
                                            class="form-control @error('transferValidation.beneficiary_name_max_words') is-invalid @enderror"
                                            wire:model="transferValidation.beneficiary_name_max_words" min="1"
                                            max="100" placeholder="مثال: 10" />
                                        @error('transferValidation.beneficiary_name_max_words')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                        <small class="form-text text-muted">أقصى عدد من الكلمات المسموح لاسم
                                            المستفيد</small>
                                    </div>
                                </div>

                                <div class="row mt-3">
                                    <div class="col-md-6">
                                        <div class="form-check form-switch">
                                            <input class="form-check-input" type="checkbox"
                                                wire:model="transferValidation.require_beneficiary_name"
                                                id="require_beneficiary_name">
                                            <label class="form-check-label fw-bold" for="require_beneficiary_name">
                                                اسم المستفيد مطلوب
                                            </label>
                                        </div>
                                        <small class="form-text text-muted">إجبارية إدخال اسم المستفيد في كل
                                            تحويل</small>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="form-check form-switch">
                                            <input class="form-check-input" type="checkbox"
                                                wire:model="transferValidation.allow_special_chars_in_name"
                                                id="allow_special_chars_in_name">
                                            <label class="form-check-label fw-bold" for="allow_special_chars_in_name">
                                                السماح بالأحرف الخاصة
                                            </label>
                                        </div>
                                        <small class="form-text text-muted">السماح باستخدام الأحرف الخاصة في اسم
                                            المستفيد</small>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Phone Number Settings -->
                <div class="row mb-4">
                    <div class="col-12">
                        <div class="card border-success border-2">
                            <div class="card-header bg-success text-white">
                                <h6 class="mb-0">
                                    <i class="ti ti-phone me-2"></i>
                                    إعدادات رقم الهاتف
                                </h6>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-6">
                                        <label class="form-label fw-bold">
                                            الحد الأدنى لعدد الأحرف
                                            <span class="text-danger">*</span>
                                        </label>
                                        <input type="number"
                                            class="form-control @error('transferValidation.phone_number_min_chars') is-invalid @enderror"
                                            wire:model="transferValidation.phone_number_min_chars" min="5"
                                            max="20" placeholder="مثال: 8" />
                                        @error('transferValidation.phone_number_min_chars')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                        <small class="form-text text-muted">أقل عدد من الأحرف المطلوبة لرقم
                                            الهاتف</small>
                                    </div>

                                    <div class="col-md-6">
                                        <label class="form-label fw-bold">
                                            الحد الأقصى لعدد الأحرف
                                            <span class="text-danger">*</span>
                                        </label>
                                        <input type="number"
                                            class="form-control @error('transferValidation.phone_number_max_chars') is-invalid @enderror"
                                            wire:model="transferValidation.phone_number_max_chars" min="5"
                                            max="25" placeholder="مثال: 15" />
                                        @error('transferValidation.phone_number_max_chars')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                        <small class="form-text text-muted">أقصى عدد من الأحرف المسموح لرقم
                                            الهاتف</small>
                                    </div>
                                </div>

                                <div class="row mt-3">
                                    <div class="col-md-6">
                                        <div class="form-check form-switch">
                                            <input class="form-check-input" type="checkbox"
                                                wire:model="transferValidation.require_phone_number"
                                                id="require_phone_number">
                                            <label class="form-check-label fw-bold" for="require_phone_number">
                                                رقم الهاتف مطلوب
                                            </label>
                                        </div>
                                        <small class="form-text text-muted">إجبارية إدخال رقم الهاتف في كل
                                            تحويل</small>
                                    </div>

                                    <div class="col-md-6">
                                        <label class="form-label fw-bold">تنسيق رقم الهاتف</label>
                                        <select class="form-select"
                                            wire:model="transferValidation.phone_number_format">
                                            @foreach ($phoneFormats as $value => $label)
                                                <option value="{{ $value }}">{{ $label }}</option>
                                            @endforeach
                                        </select>
                                        <small class="form-text text-muted">تنسيق رقم الهاتف المطلوب</small>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Summary Card -->
                <div class="row">
                    <div class="col-12">
                        <div class="card border-info border-2">
                            <div class="card-header bg-info text-white">
                                <h6 class="mb-0">
                                    <i class="ti ti-info-circle me-2"></i>
                                    ملخص الإعدادات الحالية
                                </h6>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-6">
                                        <h6 class="text-primary">اسم المستفيد:</h6>
                                        <ul class="list-unstyled">
                                            <li><strong>الحد الأدنى:</strong>
                                                {{ $transferValidation['beneficiary_name_min_words'] }} كلمة</li>
                                            <li><strong>الحد الأقصى:</strong>
                                                {{ $transferValidation['beneficiary_name_max_words'] }} كلمة</li>
                                            <li><strong>مطلوب:</strong>
                                                {{ $transferValidation['require_beneficiary_name'] ? 'نعم' : 'لا' }}
                                            </li>
                                            <li><strong>الأحرف الخاصة:</strong>
                                                {{ $transferValidation['allow_special_chars_in_name'] ? 'مسموح' : 'غير مسموح' }}
                                            </li>
                                        </ul>
                                    </div>
                                    <div class="col-md-6">
                                        <h6 class="text-success">رقم الهاتف:</h6>
                                        <ul class="list-unstyled">
                                            <li><strong>الحد الأدنى:</strong>
                                                {{ $transferValidation['phone_number_min_chars'] }} حرف</li>
                                            <li><strong>الحد الأقصى:</strong>
                                                {{ $transferValidation['phone_number_max_chars'] }} حرف</li>
                                            <li><strong>مطلوب:</strong>
                                                {{ $transferValidation['require_phone_number'] ? 'نعم' : 'لا' }}</li>
                                            <li><strong>التنسيق:</strong>
                                                {{ $phoneFormats[$transferValidation['phone_number_format']] ?? 'غير محدد' }}
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Action Buttons -->
                <div class="row mt-4">
                    <div class="col-12 text-center">
                        <button type="submit" class="btn btn-primary btn-lg me-3" wire:loading.attr="disabled">
                            <span wire:loading.remove>
                                <i class="ti ti-device-floppy me-2"></i>
                                حفظ الإعدادات
                            </span>
                            <span wire:loading>
                                <i class="ti ti-loader me-2"></i>
                                جاري الحفظ...
                            </span>
                        </button>

                        <button type="button" class="btn btn-outline-secondary btn-lg" wire:click="resetToDefaults">
                            <i class="ti ti-refresh me-2"></i>
                            إعادة تعيين للافتراضي
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
