<div>
    <div class="modal fade" id="AllocatePackageToAgentModal" tabindex="-1" aria-hidden="true" wire:ignore.self>
        <div class="modal-dialog modal-lg modal-simple  " wire:ignore.self>
            <div class="modal-content">
                <div class="modal-body">
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    <div class="text-center mb-6">
                        <h4 class="address-title mb-2">{{ __('transferpackages.allocate_packages') }}</h4>

                    </div>
                    <div class="mb-3 select2_content">
                        <label for="agent-select" class="form-label"> {{ __('transferpackages.select_agent') }}</label>
                        <x-Mulk.select2 id="agent-select" class="form-select" wire:model.live="selectedAgentId">
                            <option value="">-- Choose Agent --</option>
                            <option value="all">{{ __('transferpackages.all_agents') }}</option>
                            @foreach ($availableAgents as $id => $name)
                                <option value="{{ $id }}">{{ $name }}</option>
                            @endforeach
                        </x-Mulk.select2>
                    </div>

                    {{-- Packages checklist --}}
                    @if ($selectedAgentId)
                        <div>
                            <h5>{{ __('transferpackages.available_packages') }}</h5>

                            @foreach ($packages as $package)
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" wire:model.live="assignedPackageIds"
                                        value="{{ $package->id }}" id="package-{{ $package->id }}">
                                    <label class="form-check-label" for="package-{{ $package->id }}">
                                        {{ $package->name }} ({{ $package->currency }})
                                        @if (!$package->agent_id)
                                            <span class="badge bg-secondary">Global</span>
                                        @endif
                                    </label>
                                </div>
                            @endforeach
                        </div>

                        <button class="btn btn-primary mt-3" wire:click="saveAssignments">
                            {{ __('actions.save') }}
                        </button>
                    @endif

                    @if (session()->has('success'))
                        <div class="alert alert-success mt-3">
                            {{ session('success') }}
                        </div>
                    @endif

                </div>
            </div>
        </div>
    </div>

</div>
