<div>
    <div class="modal fade" id="transferMediaModal" tabindex="-1" aria-labelledby="transferMediaModalLabel"
        aria-hidden="true" wire:ignore.self>
        <div class="modal-dialog modal-xl">
            <div class="modal-content">

                <div class="modal-header">
                    <h5 class="modal-title">{{ __('Attachments') }}</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>

                <div class="modal-body">
                    @if (!empty($mediaFiles))
                        @foreach ($mediaFiles as $collection => $files)
                            <h6 class="fw-bold text-primary text-uppercase mb-3">
                                {{ ucfirst(str_replace('_', ' ', $collection)) }}</h6>
                            <div class="row mb-4">
                                @foreach ($files as $file)
                                    <div class="col-md-3 text-center mb-3">
                                        @if (str_contains($file['mime'], 'image'))
                                            <a href="{{ $file['url'] }}" target="_blank">
                                                <img src="{{ $file['url'] }}" class="img-fluid rounded border"
                                                    style="max-height:150px;">
                                            </a>
                                        @elseif (str_contains($file['mime'], 'pdf'))
                                            <a href="{{ $file['url'] }}" target="_blank"
                                                class="btn btn-outline-primary btn-sm">
                                                {{ __('View PDF') }}
                                            </a>
                                        @else
                                            <i class="ti ti-file fs-1"></i>
                                        @endif
                                        <div class="mt-2">
                                            <a href="{{ $file['download'] }}" download
                                                class="btn btn-sm btn-outline-secondary">
                                                {{ __('Download') }}
                                            </a>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        @endforeach
                    @else
                        <p class="text-muted">{{ __('No media found.') }}</p>
                    @endif
                </div>

                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary"
                        data-bs-dismiss="modal">{{ __('Close') }}</button>
                </div>

            </div>
        </div>
    </div>

    <script>
        document.addEventListener('livewire:init', () => {
            Livewire.on('show-transfer-media-modal', () => {
                let modal = new bootstrap.Modal(document.getElementById('transferMediaModal'));
                modal.show();
            });
        });
    </script>
</div>
