<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Simple Floating Button Test</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            padding: 20px;
            background-color: #f5f5f5;
        }

        .test-content {
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            text-align: center;
        }

        .floating-button {
            position: fixed;
            bottom: 20px;
            right: 20px;
            width: 60px;
            height: 60px;
            background-color: #007bff;
            color: white;
            border: none;
            border-radius: 50%;
            font-size: 24px;
            cursor: pointer;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
            z-index: 1000;
        }

        .floating-button:hover {
            background-color: #0056b3;
            transform: scale(1.1);
        }
    </style>
</head>

<body>
    <div class="test-content">
        <div>
            <h1>Simple Floating Button Test</h1>
            <p>You should see a blue floating button in the bottom-right corner</p>
        </div>
    </div>

    <!-- Simple floating button -->
    <button class="floating-button" onclick="alert('Button clicked!')">
        +
    </button>

    <script>
        console.log('Page loaded successfully');
        console.log('Floating button should be visible');
    </script>
</body>

</html>

