@extends('layouts.layoutMaster')
@php
    $breadcrumbs = [
        ['link' => 'home', 'name' => 'Home'],
        ['link' => 'javascript:void(0)', 'name' => 'Accounting'],
        ['name' => 'Transfer Profits'],
    ];
@endphp
@section('title', 'ترحيل الأرباح')

@section('vendor-style')
    @vite(['resources/assets/vendor/libs/datatables-bs5/datatables.bootstrap5.scss', 'resources/assets/vendor/libs/apex-charts/apex-charts.scss', 'resources/assets/vendor/libs/datatables-responsive-bs5/responsive.bootstrap5.scss', 'resources/assets/vendor/libs/datatables-buttons-bs5/buttons.bootstrap5.scss', 'resources/assets/vendor/libs/select2/select2.scss', 'resources/assets/vendor/libs/@form-validation/form-validation.scss', 'resources/assets/vendor/libs/animate-css/animate.scss', 'resources/assets/vendor/libs/sweetalert2/sweetalert2.scss', 'resources/assets/vendor/libs/bs-stepper/bs-stepper.scss', 'resources/assets/vendor/libs/flatpickr/flatpickr.scss', 'resources/assets/vendor/libs/pickr/pickr-themes.scss'])
@endsection

@section('vendor-script')
    @vite(['resources/assets/vendor/libs/moment/moment.js', 'resources/assets/vendor/libs/datatables-bs5/datatables-bootstrap5.js', 'resources/assets/vendor/libs/select2/select2.js', 'resources/assets/vendor/libs/@form-validation/popular.js', 'resources/assets/vendor/libs/@form-validation/bootstrap5.js', 'resources/assets/vendor/libs/@form-validation/auto-focus.js', 'resources/assets/vendor/libs/cleavejs/cleave.js', 'resources/assets/vendor/libs/cleavejs/cleave-phone.js', 'resources/assets/vendor/libs/sweetalert2/sweetalert2.js', 'resources/assets/vendor/libs/bs-stepper/bs-stepper.js', 'resources/assets/vendor/libs/flatpickr/flatpickr.js', 'resources/assets/vendor/libs/pickr/pickr.js'])
@endsection

@section('page-script')
    {{ $dataTable->scripts(attributes: ['type' => 'module']) }}

    <script>
        $(document).ready(function() {
            let currentAccountUuid = null;
            let currentAccountCode = null;

            // Handle transfer button click
            $(document).on('click', '.transfer-btn', function() {
                currentAccountUuid = $(this).data('account-uuid');
                currentAccountCode = $(this).data('account-code');
                const accountName = $(this).data('account-name');

                $('#accountName').text(accountName);
                $('#accountCode').text(currentAccountCode);
                $('#transferModal').modal('show');
            });

            // Handle confirm transfer
            $('#confirmTransfer').click(function() {
                if (!currentAccountUuid || !currentAccountCode) {
                    alert('خطأ في البيانات');
                    return;
                }

                // Show loading
                $(this).prop('disabled', true).html(
                    '<i class="fas fa-spinner fa-spin"></i> جاري الترحيل...');

                // Make AJAX request
                $.ajax({
                    url: '{{ route('transfer-profit.transfer') }}',
                    method: 'POST',
                    data: {
                        account_uuid: currentAccountUuid,
                        account_code: currentAccountCode,
                        _token: '{{ csrf_token() }}'
                    },
                    success: function(response) {
                        if (response.success) {
                            toastr.success(response.message);
                            $('#transferModal').modal('hide');
                            // Reload DataTable
                            $('#transferprofit-table').DataTable().ajax.reload();
                        } else {
                            toastr.error('حدث خطأ أثناء ترحيل الأرباح');
                        }
                    },
                    error: function(xhr) {
                        const response = xhr.responseJSON;
                        const message = response?.message || 'حدث خطأ أثناء ترحيل الأرباح';
                        toastr.error(message);
                    },
                    complete: function() {
                        // Reset button
                        $('#confirmTransfer').prop('disabled', false).html('تأكيد الترحيل');
                    }
                });
            });
        });
    </script>
@endsection

@section('page-style')
    <style>
        .balance-positive {
            color: #dc3545 !important;
            font-weight: bold;
        }

        .balance-negative {
            color: #0d6efd !important;
            font-weight: bold;
        }

        .balance-zero {
            color: #6c757d !important;
        }

        /* Make the table more readable */
        #transferprofit-table td {
            vertical-align: middle;
        }

        #transferprofit-table .text-end {
            text-align: right !important;
            font-family: 'Courier New', monospace;
        }
    </style>
@endsection

@section('content')
    <div class="card">
        <div class="card-header">
            <h4 class="card-title">
                <i class="fas fa-exchange-alt me-2"></i>
                ترحيل الأرباح
            </h4>
            <p class="card-text">
                <i class="fas fa-info-circle me-1"></i>
                عرض جميع الحسابات تحت 4000 مع أرصدتها بالعملات المختلفة
                <br>
                <small class="text-muted">
                    <span class="balance-positive">الأرصدة الموجبة</span> |
                    <span class="balance-negative">الأرصدة السالبة</span> |
                    <span class="balance-zero">الأرصدة الصفرية</span>
                </small>
            </p>
        </div>
        <div class="card-datatable table-responsive">
            {{ $dataTable->table(['class' => 'table table-hover', 'style' => 'width:100%'], true) }}
        </div>
    </div>

    <!-- Transfer Modal -->
    <div class="modal fade" id="transferModal" tabindex="-1" aria-labelledby="transferModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="transferModalLabel">تأكيد ترحيل الأرباح</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p>هل أنت متأكد من ترحيل الأرباح للحساب: <strong id="accountName"></strong>؟</p>
                    <p>كود الحساب: <strong id="accountCode"></strong></p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                    <button type="button" class="btn btn-success" id="confirmTransfer">تأكيد الترحيل</button>
                </div>
            </div>
        </div>
    </div>
@endsection
