@extends('layouts.layoutMaster')

@section('title', 'Debug Trial Balance')

@section('content')
<div class="container-xxl flex-grow-1 container-p-y">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title">Debug Trial Balance</h5>
                </div>
                <div class="card-body">
                    <h6>Testing Basic Route:</h6>
                    <p>✅ Route is working - you can see this page</p>
                    
                    <h6>Testing Livewire Component:</h6>
                    @livewire('trial-balance.trial-balance-index')
                    
                    <h6>Testing Direct Component Call:</h6>
                    @php
                        try {
                            $component = new \App\Livewire\TrialBalance\TrialBalanceIndex();
                            echo "✅ Component class exists and can be instantiated";
                        } catch (Exception $e) {
                            echo "❌ Error creating component: " . $e->getMessage();
                        }
                    @endphp
                    
                    <h6>Testing Models:</h6>
                    @php
                        try {
                            $currencies = \Abivia\Ledger\Models\LedgerCurrency::count();
                            echo "✅ LedgerCurrency model working - Found {$currencies} currencies";
                        } catch (Exception $e) {
                            echo "❌ Error with LedgerCurrency: " . $e->getMessage();
                        }
                        
                        echo "<br>";
                        
                        try {
                            $domains = \Abivia\Ledger\Models\LedgerDomain::count();
                            echo "✅ LedgerDomain model working - Found {$domains} domains";
                        } catch (Exception $e) {
                            echo "❌ Error with LedgerDomain: " . $e->getMessage();
                        }
                    @endphp
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

